﻿###########################################################
#
# make_abbreviated_word_list.pl
#
# 
#
#
#
# written by  Shota Sumino
#
##########################################################

package test_another_name_list; 
require 'util.pl';
require 'make_abstracted_page_data.pl';

use Encode qw(encode decode);
use utf8;                             # ソースがutf-8で書かれていることの宣言 :windows用
#binmode STDOUT, ':encoding(shiftjis)';# 標準出力はutf-8からshiftjisへ変換 :windows用
#binmode STDERR, ':encoding(shiftjis)';# 標準エラーはutf-8からshiftjisへ変換 :windows用
#binmode STDIN, ':encoding(shiftjis)'; # 標準入力はshiftjisからutf-8へ変換 :windows用


sub test_another_name_list
{
  my($redirect_list_filename, $abstracted_page_data_filename, $use_word_flag, $redirect_flag);
  my(@title_list, @redirect_list, @abbreviate_word_lsit, $filename);
  $redirect_list_filename = $_[0];
  $abstracted_page_data_filename = $_[1];
  $use_word_flag = $_[2];
  $redirect_flag = $_[3];

  
  @title_list = ();
  @redirect_list = ();

  #リダイレクトリストファイルから、リダイレクトデータを読み込む
  load_redirect_data($redirect_list_filename, \@title_list, \@redirect_list);

  @abbreviate_word_list = ();

  print"data loaded\n";

  #略語辞書の作成
  $filename = get_abbreviate_word_list(\@title_list, \@abbreviate_word_list, \@redirect_list, $abstracted_page_data_filename, $use_word_flag, $redirect_flag);

  return($filename);
}

#略語辞書の作成
sub get_abbreviate_word_list
{
  my($title_list, $another_name, $predicable, $redirect_list, $page_filename, $use_word_flag, $redirect_flag);
  my($article, $flag, $filename, $handle, $num);

  $title_list = $_[0];
  $redirect_list = $_[2];
  $page_filename = $_[3];
  $use_word_flag = $_[4];
  $redirect_flag = $_[5];

  $num =0;

  #出力ファイル名を作成して、ファイルを開く
  $filename1 = "another_name_list.txt";
  open(WRITE_FH1, ">:utf8", $filename1);
  $filename2 = "predicable_list.txt";
  open(WRITE_FH2, ">:utf8", $filename2);
  #ページデータファイルを開く
  open($handle, "<:utf8", $page_filename);
  while(1)
    {
      #記事データを1つずつ読み込む
      ($article, $flag) = get_article($handle);

      #記事データを読み込めなくなったら終了
      if($flag == 0)
        {
          close($handle);
          close(WRITE_FH);
          return($filename);
        }

      #記事データから略語を抽出
      ($another_name,$predicable) = add_abbreviate_word($article, $title_list, $redirect_list, $use_word_flag, $num, $redirect_flag);
      #抽出した略語を出力ファイルへ書き込む
      write_abbreviate_word($another_name, $$title_list[$num], WRITE_FH1);
      write_abbreviate_word($predicable, $$title_list[$num], WRITE_FH2);
      $num++;
      print"$num\n";
    }

}

#記事データを1つずつ読み込む
sub get_article
{
  my($page_handle);
  my($article, $line, $flag);
  $page_handle = $_[0];

  $article = "";
  $flag = 0;

  while($line = <$page_handle>)
    {
      if($flag == 0)#記事開始位置発見前状態：開始位置発見まで読み込みの繰り返し
        {
          if($line =~ m|<page>|)
            {
              $flag = 1;
            }
        }

      if($flag == 1)#記事開始位置発見済み：記事終了位置発見まで読み込み＆保存の繰り返し
        {
          $article = $article.$line;
          if($line =~ m|</page>|)
            {
              return($article, 1);
            }
        }
    }

  #記事データを読み込めなかったら0を返して終了
  return("", 0);
}

#出力ファイルへデータの書き込みを行う
sub write_abbreviate_word
{
  my($word_list, $filename, $title_list);
  my($num, $i, $handle);
  $word = $_[0];
  $title = $_[1];
  $handle = $_[2];


  if($word =~ /.+/)
    {
      print $handle "$title -> $word\n";
    }

  return($filename);
}

#記事データから略語の抽出を行う
sub add_abbreviate_word
{
  my($article, $abbreviate_word_list, $title_list, $redirect_list, $use_word_flag, $num, $redirect_flag);
  my($title, $str1, $str2);
  my($j, %abbreviate_word);
  $article = $_[0];
  $title_list = $_[1];
  $redirect_list = $_[2];
  $use_word_flag = $_[3];
  $num = $_[4];
  $redirect_flag = $_[5];


  #タイトルの抽出
  $article =~ m|<title>(.*)</title>|;
  $title = $1;

  

  #略語候補の抽出
  %abbreviate_word = get_abbreviate_word($article, $title);

  $str1 = $abbreviate_word{0};
  $str2 = $abbreviate_word{1};


  #参照文字の変換
  $str1 =~ s/&amp;/&/g;
  $str1 =~ s/&lt;/</g;
  $str1 =~ s/&gt;/>/g;
  $str1 =~ s/&quot;/"/g;#"
  $str1 =~ s/&apos;/'/g;#'
    

  return($str1,$str2);
}


#略語の整形を行う
sub remediation
{
  my($word);
  $word = $_[0];

  
  if($word =~ /(.*)[(（].+[)）](.*)/)#()とその中の文字を取り除く
    {
      $word = $1.$2;
    }

    if($word =~ /『(.+)』/)#『』を取り除く
    {
      $word = $1;
    }

    if($word =~ /["“](.+)["”]/)#"”を取り除く
    {
      $word = $1;
    }

    if($word =~ /''([^']+)''/)#文字列が''で囲まれている場合、取り除く [']
    {
      $word = $1;
    }

   if($word =~ /([^\[]*)\[\[(.+\|)*(.*)\]\]([^\]]*)/)#aaa[[xxx|yyy]]bbbからaaayyybbbを抜き出す
    {
      $word = $1.$3.$4;
    }

   if($word =~ /([^\{]*){{(.+\|)*(.*)}}([^\}]*)/)#aaa{{xxx|yyy}}bbbからaaayyybbbを抜き出す
    {
      $word = $1.$3.$4;
    }


#print"$word\n";
  return($word);
}



sub get_bit
{
  my($data, $num);
  $data = $_[0];
  $num = $_[1];

  if($num < 1)
    {
      return(-1);
    }

  if($num == 1)
    {
      return($data % 2);
    }
  else
    {
      get_bit($data/2, $num-1);
    }
}


#@$group中に$wordが含まれているか調べる
sub check_exist
{
  my($word, $group, $num, $i);
  $word = $_[0];
  $group = $_[1];

  $num = @$group;
  for($i=0;$i<$num;$i++)
    {
      if($word eq $$group[$i])
        {
          return(1);
        }
    }
  return(0);
}

#記事データから略語候補を抽出する
sub get_abbreviate_word
{
  my($i, $j, @temp, @temp2, $temp_str,@info_split_word);
  my($article, %abbreviate_word, @start_word, $flag, @info_start_word);
  my(@str, $title, $start, $end, $start2, $end2);
  $article = $_[0];
  $title = $_[1];
  @temp = ();
  @temp2 = ();
  @str = ();
  
  %abbreviate_word = ();


  $flag = index($article,"==");
  $article = substr($article,0,$flag);


  if($title =~ /ゲーム機/)
    {
      open(WR, ">>:utf8", "test_page.txt");
      print WR "$article\n";
      close(WR);
    }
  
  #基本情報から異表記、属性を抽出する
  #とりあえず後回し
  if(0)
    {
  for($i=0;$i<@info_start_word;$i++)
    {
      if($info_start_word[$i] =~ /.+/)
        {
          #print"$start_word[$i] $i\n";
          $info_start_word[$i] = quotemeta($info_start_word[$i]);
          #基本情報中に略称、愛称、通称があればその情報を抜き出す
          if($article =~ /\| *$info_start_word[$i] *=([^\|]*)\n\|/)
            {
              $temp_str = $1;
              #改行タグを区切り文字「、」に置き換える
              $temp_str =~ s/\&lt\;br\/\&gt\;/、/ig;
              $temp_str =~ s/\&lt\;br\&gt\;/、/ig;
              $temp_str =~ s/\&lt\;br \/\&gt\;/、/ig;
              #コメントアウト部分を削除する
              $temp_str =~ s/\&lt\;!--[^-]*--\&gt\;//g;
              #脚注用の文章を削除する
              $temp_str =~ s/\&lt\;ref((?!\/ref\&gt\;).)*\/ref\&gt\;//g;
              $temp_str =~ s/\&lt\;ref((?!\&gt\;).)*\&gt\;//g;
              #丸括弧と、それにに囲まれた部分を削除する
              $temp_str =~ s/[(（][^)）]+[)）]//g;
              #スペースを削除する
              $temp_str =~ s/ //g;

              #基本情報での略語区切り文字で基本情報を分割する
              #現在は区切り文字は「、」の1種類
              if($temp_str =~ /[^ ]+/)
                {
                  @temp2 = split(/[$info_split_word[0]]/,$temp_str);
                }

              #分割したものを略語候補として保存
              for($j=0;$j<@temp2;$j++)
                {
                  if($abbreviate_word{$i} =~ /.+/)
                    {
                      $abbreviate_word{$i} .= ",,$temp2[$j]";
                    }
                  else
                    {
                      $abbreviate_word{$i} = "$temp2[$j]";
                    }
                  
                }
           }
       }
    }
   }

  #以下、異表記の抽出のつもり

if($title =~ /ゲーム機/)
{
  print "$article\n";
}

#改行文字除去
$article =~ s/\r//g;
$article =~ s/\n//g;
#注釈除去
  $article =~ s/\&lt\;ref((?!\&gt\;).)*\/\&gt\;//g;
  $article =~ s/\&lt\;ref((?!\/ref\&gt\;).)*\/ref\&gt\;//g;
  $article =~ s/\&lt\;ref((?!\&gt\;).)*\&gt\;//g;

if($title =~ /ゲーム機/)
{
  print "$article\n";
}


  #$article =~ s/\&lt\;ref((?!\/ref\&gt\;).)*\/ref\&gt\;//g;
  #$article =~ s/\&lt\;ref((?!\&gt\;).)*\&gt\;//g;

  #人名中の空白除去処理
  $str_ = "";
  while($str_ ne $article)
  {
    $str_ = $article;
    $article =~ s/\{(.*) (.*)\}/{$1aaaaa$2}/;
  }
  $article =~ s/ //g;
  $str_ = "";
  while($str_ ne $article)
  {
    $str_ = $article;
    $article =~ s/\{(.*)aaaaa(.*)\}/{$1 $2}/;
  }

#アブスト以外のタイトル除去処理
  $str_ = "";
  while($str_ ne $article)
  {
    $str_ = $article;
    $article =~ s/\{([^\{\}]*)'''$title'''([^\{\}]*)\}/{$1$2}/;
  }


  $start_title = index($article, "'''$title'''");
if($start2 == -1)
{
  $abbreviate_word{0} = "";
  $abbreviate_word{1} = "";
    return(%abbreviate_word);
}

  $start = index($article,"(", $start_title-1);
  $end = index($article,")", $start_title-1);
  $end2 = index($article,"）", $start_title-1);
  $start2 = index($article,"（", $start_title-1);





if($start == -1 && $start2 == -1)
{
  $abbreviate_word{0} = "";
  $abbreviate_word{1} = "";
    return(%abbreviate_word);
}


  if(($start < $start2 && $start != -1) || ($start2 == -1 && $start != -1))
  {
    $end = $end-$start-1;
    $start = $start+1;
  }
  else
  {
    $end = $end2-$start2-1;
    $start = $start2+1;
  }

if(1)
{
  $temp = $start - $start_title - length($title) - 6;
#print"$temp\n";
  if($start - $start_title - length($title)  > 10)
    {
  $abbreviate_word{0} = "";
  $abbreviate_word{1} = "";
    return(%abbreviate_word);
    }
}
    $abbreviate_word{0} = substr($article,$start,$end);


if(1)
{
  $str_ = "";
  while($str_ ne $abbreviate_word{0})
  {
    $str_ = $abbreviate_word{0};
    $abbreviate_word{0} =~ s/{{([^\{\}]+\|)*([^\{\}]*)}}/$2/;
  }

  #コメントアウト削除
  $abbreviate_word{0} =~ s/&lt;!--.*--&gt;//g;

  @temp = split(/[、,　]/,$abbreviate_word{0});

  
  for($i=0;$i<@temp;$i++)
    {
      #'を削除  '
      #'で囲まれた中の文字のみを抜き出し
      $temp[$i] =~ s/[^']*'''([^']+)'''[^']*/$1/g; #'
      $temp[$i] =~ s/[^']*''([^']+)''[^']*/$1/g; #'
      $temp[$i] =~ s/[^']*'([^']+)'[^']*/$1/g; #'
      
      #
      $temp[$i] =~ s/[(（](.*)//g;
      #：があったら、その後の部分を抜き出す
      $temp[$i] =~ s/([^:：]*)[:：]([^:：]*)/$2/;

      if($temp[$i] =~ /\[\[[^\[\]]+年[^\[\]]*\]\]/ || $temp[$i] =~ /\[\[[0-9]+月[0-9]日\]\]/)
      {
        $temp[$i] = "";
      }
      $temp[$i] =~ s/\[\[[^\[\]]*\]\]//g;
    }



  #連結作業
  $abbreviate_word{0} = $temp[0];
  for($i=1;$i<@temp;$i++)
    {
      if($temp[$i] ne "")
      {
        $abbreviate_word{0} .= ",," . $temp[$i];
      }
    }
}

  $start = index($article,")") + 1;
  $end = index($article,"。");
  $abbreviate_word{1} = substr($article,$start,$end);


  return(%abbreviate_word);
}

#リダイレクトリストファイルから、リダイレクトデータを読み込む
sub load_redirect_data
{
  my($i, $j);
  my($filename);
  my($list1, $list2, $line, $num);

  $list1 = $_[1];
  $list2 = $_[2];

  $filename = $_[0];

  open(FH, "<:utf8", $filename);
  $num = 0;

  while($line = <FH>)
    {
      @temp = split(/ -> /, $line);
      $$list1[$num] = $temp[0];
      $$list2[$num] = $temp[1];
      $num++;
    }

  close(FH);
  return(\@list2, \@list2);

}