﻿###########################################################
#
# make_redirect_list
#
# 
#
#
#
# written by  Shota Sumino
#
##########################################################

package make_redirect_list; 
require 'util.pl';
use Class::Struct;

use Encode qw(encode decode);
use utf8;    


struct redirect_data => {
  to => '$',
  from => '$',
  from_num => '$'
};


sub make_redirect_list
{
  my($i,$j);
  my(@redirect_data_list);
  my($dirname, $filename_key, $filename);

  $dirname = $_[0];
  $filename_key = $_[1];

  
  print"Now, reading redirect file.\n";
  #リダイレクトリストの読み込み
  @redirect_data_list = get_redirect_data($dirname, $filename_key);

  print"Now, reading page file.\n";
  #リダイレクト先ページ番号を、ページ名に置き換える
  @redirect_data_list = set_page_title($dirname, $filename_key, \@redirect_data_list);

  print"Now, writing redirect data.\n";
  #リダイレクトリスト保存
  $filename = write_file(\@redirect_data_list);
  return($filename);
}

#リダイレクトリストの書き込み
sub write_file
{
  my($i, $j, $key, $data, $filename);
  my($redirect_data_list,@temp);
  $redirect_data_list = $_[0];
  @temp = ();

  $filename = "redirect_title_list.txt";
  
  open(FH, ">:utf8", $filename);
  
  $j = @$redirect_data_list;
  for($i=0;$i<$j;$i++)
    {
      @temp = ($$redirect_data_list[$i]->from(), $$redirect_data_list[$i]->to());
      print FH "$temp[0] -> $temp[1]\n";
    }
  close(FH);

  return($filename);
}


#リダイレクト先ページ番号をページ名に置き換える
sub set_page_title()
{
  my($dirname, $filename_key, $redirect_data_list);
  my(%title_list);
  my($i, $j, $num);
  ($dirname, $filename_key, $redirect_data_list) = @_;
  
  %title_list = ();
  $num = @$redirect_data_list;
  for($i=0;$i<$num;$i++)
    {
      #$temp = $$redirect_data_list[$i]->from_num();
      $title_list{$$redirect_data_list[$i]->from_num()} = "init";
    }

  %title_list = get_title_list($dirname, $filename_key, \%title_list);

  $j = @$redirect_data_list;
  for($i=0;$i<$num;$i++)
    {
      $$redirect_data_list[$i]->from($title_list{$$redirect_data_list[$i]->from_num()});
    }
  return(@$redirect_data_list);
}

#ページファイルから、ページ名とページ番号の組みを読みこむ
sub get_title_list
{
  my($dirname, $filename);
  my($title_list);
  my($handle);
  my($i);
  $dirname = $_[0];
  $filename = "jawiki-".$_[1]."-page.sql";
  $title_list = $_[2];

  $handle = util::get_filehandle($dirname, $filename);

  while($line = <$handle>)
    {
      chomp($line);
      if($line =~ /^INSERT INTO `page`/)
        {
          %$title_list = get_title($line, $title_list);
  #$j = $$title_list{'1391854'};
  #print"$j\n";
        }
    }
  close($handle);


  return(%$title_list);
}


sub get_title
{
  my($line,@temp);
  my($title_list);

  $line = $_[0];
  $title_list = $_[1];
  #@temp = $line =~ /\([0-9]*,[0-9]*,'[^']*','[^']*',[0-9]*,[0-9]*,[0-9]*,[0-9\.]*,'[0-9]*',[0-9]*,[0-9]*\)/ig;
  @temp = $line =~ /\([0-9]*,[0-9]*,'[^']*',[^\)]*\)/ig;

                                              
  for($i=0;$i<@temp;$i++)
    {
      #print"$temp[$i]\n";
      
      #$temp[$i] =~ /\(([0-9]*),[0-9]*,'([^']*)','[^']*',[0-9]*,[0-9]*,[0-9]*,[0-9\.]*,'[0-9]*',[0-9]*,[0-9]*\)/;
      $temp[$i] =~ /\(([0-9]*),[0-9]*,'([^']*)'[^\)]*\)/;


      if(exists($$title_list{$1}))
        {

          $$title_list{$1} = $2;
        }

    }

  return(%$title_list);
}

#リダイレクトファイルからリダイレクト情報を取得する
sub get_redirect_data
{
  my($i,$j);
  my($dir_name, $redirect_filename);
  my(@redirect_data_list, @temp_list, @return_list);
  my($handle);

  $dir_name = $_[0];
  $redirect_filename = "jawiki-".$_[1]."-redirect.sql";

  @redirect_data_list = ();
  @return_list = ();

  
  $handle = util::get_filehandle($dir_name, $redirect_filename);
  $i=0;
  while($line = <$handle>)
    {
      chomp($line);
      #print"$line\n";
      if($line =~ /^INSERT INTO `redirect`/)
        {
          @temp_list = get_redirect($line);
          push(@redirect_data_list, @temp_list);
        }
    }
  #print "line num = $i\n";
  close($handle);

  return(@redirect_data_list);
}

sub get_redirect#jawiki-$1-redirect.sqlから読み取った文字列から、リダイレクト情報を抽出する
{
  my($i, $j, $line, @temp, $exception_flag, $num);
  my(@redirect_data_list);
  
  @redirect_data_list = ();

  $line = $_[0];
  @temp = $line =~ /\([^\(\)]+,[^\(\)]+,[^\(\)]+,[^\(\)]+,[^\(\)]+\)/g;

  $num = 0;
  for($i=0;$i<@temp;$i++)
    {
      $temp[$i] =~ /([0-9]+),([0-9]+),'([^']+)','([^']*)','([^']*)'/; #'/;


      $exception_flag = 1;#例外処理1-1実行フラグ　
                          #$exception_flag=1のとき、$5に文字を含むリダイレクトは出力リストに追加されません
                          #$exception_flag=0のとき、すべてのリダイレクトが出力リストに追加されます
      if(!($5 =~ /.+/) || !($exception_flag))
        {
          $redirect_data_list[$num] = new redirect_data;
          $redirect_data_list[$num]->to($3);
          $redirect_data_list[$num]->from_num($1);
          $num++;
        }
    }

  return(@redirect_data_list);
}


1;