﻿###########################################################
#
# make_abstracted_page_data.pl
#
# 
#
#
#
# written by  Shota Sumino
#
##########################################################

package make_abstracted_page_data; 
require 'util.pl';

use Encode qw(encode decode);
use utf8;

#全記事データから、リダイレクトリストの「リダイレクト先」に含まれる記事を抽出する
sub make_abstracted_page_data
{
  my($dirname, $filename_key, $redirect_filename, $abstracted_page_filename, $redirect_filename2);
  my(%title_list);
  my($ret1, $ret2);
  $dirname = $_[0];
  $filename_key = $_[1];
  $redirect_filename = $_[2];

  %title_list = get_redirected_title($redirect_filename);

  ($abstracted_page_filename, $redirect_filename2) = make_abstracted_page($dirname, $filename_key, \%title_list);
  return($abstracted_page_filename, $redirect_filename2);
}

sub make_abstracted_page
{
  my($dirname, $filename_key, $title_list, $page_filename, $write_filename, $redirect_filename2);
  my($page_handle, $write_handle, $temp);
  $dirname = $_[0];
  $filename_key = $_[1];
  $title_list = $_[2];

  #リダイレクトリストのソートしたものの出力先を開く
  $redirect_filename2 = "redirect_title_list_sorted.txt";
  open(RED_FH, ">:utf8", $redirect_filename2);


  #抽出した記事の出力先を読み込み
  $write_filename = "abstracted_page_data.dat";
  open(FH, ">:utf8", $write_filename);

  
  #記事データ読み込み
  $page_filename = "jawiki-".$filename_key."-pages-articles.xml";

  #ページデータが存在するかチェック
  if(util::check_fileexist($dirname, $page_filename) == 1)
    {
      $page_handle = util::get_filehandle($dirname, $page_filename);
  
      #記事データの抽出と書き込みを行う
      read_write_abstract_data($page_handle, FH, $title_list, RED_FH);
    }
  else
    {
      $temp = 0;
      $page_filename = "jawiki-".$filename_key."-pages-articles1.xml";
      if((util::check_fileexist($dirname, $page_filename) == 1))
        {
          $page_handle = util::get_filehandle($dirname, $page_filename);
  
          #記事データの抽出と書き込みを行う
          read_write_abstract_data($page_handle, FH, $title_list, RED_FH);

          $temp++;
        }
      
      $page_filename = "jawiki-".$filename_key."-pages-articles2.xml";
      if((util::check_fileexist($dirname, $page_filename) == 1))
        {
          $page_handle = util::get_filehandle($dirname, $page_filename);
  
          #記事データの抽出と書き込みを行う
          read_write_abstract_data($page_handle, FH, $title_list, RED_FH);

          $temp++;
        }
      
      $page_filename = "jawiki-".$filename_key."-pages-articles3.xml";
      if((util::check_fileexist($dirname, $page_filename) == 1))
        {
          $page_handle = util::get_filehandle($dirname, $page_filename);
  
          #記事データの抽出と書き込みを行う
          read_write_abstract_data($page_handle, FH, $title_list, RED_FH);

          $temp++;
        }
      
      $page_filename = "jawiki-".$filename_key."-pages-articles4.xml";
      if((util::check_fileexist($dirname, $page_filename) == 1))
        {
          $page_handle = util::get_filehandle($dirname, $page_filename);
  
          #記事データの抽出と書き込みを行う
          read_write_abstract_data($page_handle, FH, $title_list, RED_FH);

          $temp++;
        }

      if($temp == 0)
        {
          print "page file is not exist!!\n";
          exit();
        }
    }
  close(FH);
  
  return($write_filename, $redirect_filename2);
}

#記事データの抽出と書き込みを行う
sub read_write_abstract_data
{
  my($page_handle, $write_handle, $title_list,$redirect2_handle);
  my($article, $flag, $temp, $temp2, $title);
  $page_handle =$_[0];
  $write_handle = $_[1];
  $title_list = $_[2];
  $redirect2_handle = $_[3];

  $temp = 0;
  $temp2 = 0;

  if(0)#Linux環境実験用の処理
    {
      ($article, $flag) = get_article($page_handle);#記事を１つだけ読み込み
      
      print "$article\n\n\n";#コンソールに記事を出力
      write_article($write_handle, $article);#abstracted_page_data.datに記事を出力

      
      $article =~ m|<title>(.*)</title>|;
      $title = $1;
      print "$title\n"; #記事からタイトルを抜き出してコンソールに出力
      print $write_handle "\n\n\ntitle : $title\n";#タイトルをabstracted_page_data.datに出力
      
      return();
    }

  
  while(1)
    {
      #記事データを1つづつ抽出
      ($article, $flag) = get_article($page_handle);

      #記事データが読み込めなくなったら終了
      if($flag == 0)
        {
          return();
        }
      #抽出した記事のタイトルが、リダイレクトリストに含まれているかどうかチェック
      if(check_title($article, $title_list))
        {
          
          $article =~ m|<title>(.*)</title>|;
          $title = $1;
          
          #書き込み
          #通常書き込み
          write_article($write_handle, $article);
          
          #記事データが出てきた順にリダイレクトリストも書き込み
          write_redirect_file2($redirect2_handle, $title, $$title_list{$title});
          
          print"$temp $temp2\n";
          $temp++;
        }
      $temp2++;
    }
}

sub write_redirect_file2
{
  my($handle);
  $handle = $_[0];
  print $handle "$_[1] -> $_[2]\n";
}

sub write_article
{
  my($write_handle, $article);
  $write_handle = $_[0];
  $article = $_[1];

  print $write_handle "$article\n";

}

sub check_title
{
  my($article, $titile_list, $title);
  $article = $_[0];
  $title_list = $_[1];

  $article =~ m|<title>(.*)</title>|;
  $title = $1;


  if(exists($$title_list{$title}))
    {
      return(1);
    }
  return(0);
}

sub get_article
{
  my($page_handle);
  my($article, $line, $flag);
  $page_handle = $_[0];

  $article = "";
  $flag = 0;

  while($line = <$page_handle>)
    {
      if($flag == 0)#記事開始位置発見前状態：開始位置発見まで読み込みの繰り返し
        {
          if($line =~ m|<page>|)
            {
              $flag = 1;
            }
        }

      if($flag == 1)#記事開始位置発見済み：記事終了位置発見まで読み込み＆保存の繰り返し
        {
          $article = $article.$line;
          if($line =~ m|</page>|)
            {
              return($article, 1);
            }
        }
    }
  return("", 0);
}

sub get_redirected_title#「リダイレクト先タイトル」をキーとして、「リダイレクト元タイトル」を出力する連想配列を作成する
{
  my($i, $j, $line, @temp, $init_flag, $init);
  my($redirect, $filename);
  my(%title_list);
  $redirect_filename = $_[0];
  $init_flag = $_[1];
  $init = $_[2];
  %title_list = ();


  if(!open(FH, "<:utf8", $redirect_filename))
  {
    print "Error!! : $redirect_filename is not found\n";
   exit(0);
 }
  
  while($line = <FH>)
    {
      chomp($line);
      @temp = split(/ -> /, $line);

      if(!($init_flag))
        {
          if(exists($title_list{$temp[1]}))
            {
              $title_list{$temp[1]} .= ",$temp[0]";
            }
          else
            {
              $title_list{$temp[1]} = "$temp[0]";
            }
        }
      else
        {
          $title_list{$temp[1]} = $init;
        }
    }
  close(FH);

  return(%title_list);
}

1;