﻿###########################################################
#
# make_abbreviated_word_list.pl
#
# 
#
#
#
# written by  Shota Sumino
#
##########################################################

package make_abbreviated_word_list; 
require 'util.pl';
require 'make_abstracted_page_data.pl';

use Encode qw(encode decode);
use utf8;                             # ソースがutf-8で書かれていることの宣言 :windows用
#binmode STDOUT, ':encoding(shiftjis)';# 標準出力はutf-8からshiftjisへ変換 :windows用
#binmode STDERR, ':encoding(shiftjis)';# 標準エラーはutf-8からshiftjisへ変換 :windows用
#binmode STDIN, ':encoding(shiftjis)'; # 標準入力はshiftjisからutf-8へ変換 :windows用


sub make_abbreviated_word_list
{
  my($redirect_list_filename, $abstracted_page_data_filename, $use_word_flag, $redirect_flag);
  my(@title_list, @redirect_list, @abbreviate_word_lsit, $filename);
  $redirect_list_filename = $_[0];
  $abstracted_page_data_filename = $_[1];
  $use_word_flag = $_[2];
  $redirect_flag = $_[3];

  
  @title_list = ();
  @redirect_list = ();

  #リダイレクトリストファイルから、リダイレクトデータを読み込む
  load_redirect_data($redirect_list_filename, \@title_list, \@redirect_list);

  @abbreviate_word_list = ();

  print"data loaded\n";

  #略語辞書の作成
  $filename = get_abbreviate_word_list(\@title_list, \@abbreviate_word_list, \@redirect_list, $abstracted_page_data_filename, $use_word_flag, $redirect_flag);

  return($filename);
}

#略語辞書の作成
sub get_abbreviate_word_list
{
  my($title_list, $abbreviate_word, $redirect_list, $page_filename, $use_word_flag, $redirect_flag);
  my($article, $flag, $filename, $handle, $num);

  $title_list = $_[0];
  $redirect_list = $_[2];
  $page_filename = $_[3];
  $use_word_flag = $_[4];
  $redirect_flag = $_[5];

  $num =0;

  #出力ファイル名を作成して、ファイルを開く
  $filename = "abbreviate_word_".$use_word_flag."-".$redirect_flag.".txt";
  open(WRITE_FH, ">:utf8", $filename);
  #ページデータファイルを開く
  if(!open($handle, "<:utf8", $page_filename))
  {
    print "Error!! : $page_filename is not found\n";
   exit(0);
 }
  while(1)
    {
      #記事データを1つずつ読み込む
      ($article, $flag) = get_article($handle);

      #記事データを読み込めなくなったら終了
      if($flag == 0)
        {
          close($handle);
          close(WRITE_FH);
          return($filename);
        }

      #記事データから略語を抽出
      $abbreviate_word = add_abbreviate_word($article, $title_list, $redirect_list, $use_word_flag, $num, $redirect_flag);
      #抽出した略語を出力ファイルへ書き込む
      write_abbreviate_word($abbreviate_word, $$title_list[$num], WRITE_FH);
      $num++;
    }

}

#記事データを1つずつ読み込む
sub get_article
{
  my($page_handle);
  my($article, $line, $flag);
  $page_handle = $_[0];

  $article = "";
  $flag = 0;

  while($line = <$page_handle>)
    {
      if($flag == 0)#記事開始位置発見前状態：開始位置発見まで読み込みの繰り返し
        {
          if($line =~ m|<page>|)
            {
              $flag = 1;
            }
        }

      if($flag == 1)#記事開始位置発見済み：記事終了位置発見まで読み込み＆保存の繰り返し
        {
          $article = $article.$line;
          if($line =~ m|</page>|)
            {
              return($article, 1);
            }
        }
    }

  #記事データを読み込めなかったら0を返して終了
  return("", 0);
}

#出力ファイルへデータの書き込みを行う
sub write_abbreviate_word
{
  my($word_list, $filename, $title_list);
  my($num, $i, $handle);
  $word = $_[0];
  $title = $_[1];
  $handle = $_[2];


  if($word =~ /.+/)
    {
      print $handle "$title -> $word\n";
    }

  return($filename);
}

#記事データから略語の抽出を行う
sub add_abbreviate_word
{
  my($article, $abbreviate_word_list, $title_list, $redirect_list, $use_word_flag, $num, $redirect_flag);
  my($title, $str);
  my($j, %abbreviate_word);
  $article = $_[0];
  $title_list = $_[1];
  $redirect_list = $_[2];
  $use_word_flag = $_[3];
  $num = $_[4];
  $redirect_flag = $_[5];


  #タイトルの抽出
  $article =~ m|<title>(.*)</title>|;
  $title = $1;

  #略語候補の抽出
  %abbreviate_word = get_abbreviate_word($article, $title);

  #略語候補から、略語として使用するものを選択する
  #$use_ward_flag:略称、愛称、通称のどの単語をキーとするか指定する変数
  #$redirect_flag:リダイレクト情報で略語候補を間引くか指定する変数
  $str = get_custom_abbreviate_word($abbreviate_word{0}, $abbreviate_word{1}, $abbreviate_word{2},
                                    $$redirect_list[$num], $use_word_flag, $redirect_flag, $title);

  #参照文字の変換
  $str =~ s/&amp;/&/g;
  $str =~ s/&lt;/</g;
  $str =~ s/&gt;/>/g;
  $str =~ s/&quot;/"/g;#"
  $str =~ s/&apos;/'/g;#'

    

  return($str);
}

#略語候補から、略語として使用するものを選択する
sub get_custom_abbreviate_word
{
  my(@abbreviate_word, $num, $use_word_flag, $redirect_flag, $title);
  my(@words, @redirect_words, $i, $str, @input_words, @word_list2);
  @abbreviate_word = ($_[0], $_[1], $_[2]);
  $redirect_word = $_[3];
  $use_word_flag = $_[4];
  $redirect_flag = $_[5];
  @input_words = ();
  @word_list2 = ();
  $str = "";
  $title = $_[6];

 
  @redirect_words = split(/,/, $redirect_word);

  for($j=0;$j<@abbreviate_word;$j++)
    {
      #略称、愛称、通称のうち、指定されていないものはここではじかれる
      if(get_bit($use_word_flag, $j+1))
        {
          @words = split(/,,/, $abbreviate_word[$j]);
          
          for($i=0;$i<@words;$i++)
            {
              $words[$i] = remediation($words[$i]);#単語の修正:略称語の中に変な記号が入ってたりとかした場合に、それを取り除く処理
              if($words[$i] =~ /.+/)
                {
                  #略語候補がリダイレクトリストのリダイレクト元に含まれていたら通す
                  #もしくは、リダイレクト情報を使用しないならば通す
                  #check_exist($word, \@list) : @listの中に$wordが含まれていたら1を出力する
                  if(check_exist($words[$i], \@redirect_words) == 1 || !($redirect_flag == 1))
                    {
                      #既に同じ単語が略語として保存されていたら、保存しない
                      if(check_exist($words[$i], \@input_words) == 0)
                        {
                          push(@input_words, $words[$i]);
                        }
                    }
                }
            }
        }
    }
  for($i=0;$i<@input_words;$i++)
    {
      #既に同じ単語が略語として保存されていたら、保存しない
      if(check_exist($input_words[$i], \@word_list2) == 0)
        {
          push(@word_list2, $input_words[$i]);
          if($str =~ /.+/)
            {
              $str .= ",,".$input_words[$i];
            }
          else
            {
              $str = $input_words[$i];
            }
        }
    }

  return($str);
}

#略語の整形を行う
sub remediation
{
  my($word);
  $word = $_[0];

  
  if($word =~ /(.*)[(（].+[)）](.*)/)#()とその中の文字を取り除く
    {
      $word = $1.$2;
    }

    if($word =~ /『(.+)』/)#『』を取り除く
    {
      $word = $1;
    }

    if($word =~ /["“](.+)["”]/)#"”を取り除く
    {
      $word = $1;
    }

    if($word =~ /''([^']+)''/)#文字列が''で囲まれている場合、取り除く [']
    {
      $word = $1;
    }

   if($word =~ /([^\[]*)\[\[(.+\|)*(.*)\]\]([^\]]*)/)#aaa[[xxx|yyy]]bbbからaaayyybbbを抜き出す
    {
      $word = $1.$3.$4;
    }

   if($word =~ /([^\{]*){{(.+\|)*(.*)}}([^\}]*)/)#aaa{{xxx|yyy}}bbbからaaayyybbbを抜き出す
    {
      $word = $1.$3.$4;
    }


#print"$word\n";
  return($word);
}



sub get_bit
{
  my($data, $num);
  $data = $_[0];
  $num = $_[1];

  if($num < 1)
    {
      return(-1);
    }

  if($num == 1)
    {
      return($data % 2);
    }
  else
    {
      get_bit($data/2, $num-1);
    }
}


#@$group中に$wordが含まれているか調べる
sub check_exist
{
  my($word, $group, $num, $i);
  $word = $_[0];
  $group = $_[1];

  $num = @$group;
  for($i=0;$i<$num;$i++)
    {
      if($word eq $$group[$i])
        {
          return(1);
        }
    }
  return(0);
}

#記事データから略語候補を抽出する
sub get_abbreviate_word
{
  my($i, $j, @temp, @temp2, $temp_str,@info_split_word);
  my($article, %abbreviate_word, @start_word, $flag, @info_start_word);
  my(@str, $title);
  $article = $_[0];
  $title = $_[1];
  @temp = ();
  @temp2 = ();
  @str = ();
  @info_start_word = ("略称", "愛称", "");
  @info_split_word = ("、");
  
  %abbreviate_word = ();

  @start_word = ("略称は", "愛称は", "通称は");

  $flag = index($article,"==");
  $article = substr($article,0,$flag);

  
  #基本情報から略語候補を抽出する
  for($i=0;$i<@info_start_word;$i++)
    {
      if($info_start_word[$i] =~ /.+/)
        {
          #print"$start_word[$i] $i\n";
          $info_start_word[$i] = quotemeta($info_start_word[$i]);
          #基本情報中に略称、愛称、通称があればその情報を抜き出す
          if($article =~ /\| *$info_start_word[$i] *=([^\|]*)\n\|/)
            {
              $temp_str = $1;
              #改行タグを区切り文字「、」に置き換える
              $temp_str =~ s/\&lt\;br\/\&gt\;/、/ig;
              $temp_str =~ s/\&lt\;br\&gt\;/、/ig;
              $temp_str =~ s/\&lt\;br \/\&gt\;/、/ig;
              #コメントアウト部分を削除する
              $temp_str =~ s/\&lt\;!--[^-]*--\&gt\;//g;
              #脚注用の文章を削除する
              $temp_str =~ s/\&lt\;ref((?!\/ref\&gt\;).)*\/ref\&gt\;//g;
              $temp_str =~ s/\&lt\;ref((?!\&gt\;).)*\&gt\;//g;
              #丸括弧と、それにに囲まれた部分を削除する
              $temp_str =~ s/[(（][^)）]+[)）]//g;
              #スペースを削除する
              $temp_str =~ s/ //g;

              #基本情報での略語区切り文字で基本情報を分割する
              #現在は区切り文字は「、」の1種類
              if($temp_str =~ /[^ ]+/)
                {
                  @temp2 = split(/[$info_split_word[0]]/,$temp_str);
                }

              #分割したものを略語候補として保存
              for($j=0;$j<@temp2;$j++)
                {
                  if($abbreviate_word{$i} =~ /.+/)
                    {
                      $abbreviate_word{$i} .= ",,$temp2[$j]";
                    }
                  else
                    {
                      $abbreviate_word{$i} = "$temp2[$j]";
                    }
                  
                }
           }
       }
    }

  #アブスト部分からの略語候補の抽出
  for($i=0;$i<@start_word;$i++)
    {
      $temp[0] = quotemeta($start_word[$i]);
      $temp[1] = quotemeta("。");

      #略称、愛称、通称の文字があれば、その直後から文末までを抜き出す
      if($article =~ /$temp[0]([^$temp[1]]*)$temp[1]/)
        {
          $str[$i] = $1;

          #注釈用の文章を削除する
         $temp[2] = quotemeta("&lt;ref&gt;");
         $temp[3] = quotemeta("&lt;/ref&gt;");
         $str[$i] =~ s/$temp[2].*($temp[3])*$//g;


          
          $temp[0] = quotemeta("「");
          $temp[1] = quotemeta("」");
          $temp[2] = quotemeta("'''");
          $temp[3] = quotemeta("'''");

          #角括弧で囲まれた文字列があれば、略語候補として抽出
          @temp2 = ($str[$i] =~ /$temp[0]([^$temp[0]]+)$temp[1]/g);
          for($j=0;$j<@temp2;$j++)
            {
              #略語候補の整形：クォーテーションの削除
              if($temp2[$j] =~ /$temp[2]([^']*(|'|'')+[^']*)$temp[3]/)
                {
                  $temp2[$j] = $1;
                }

              #略語候補として保存
              if($abbreviate_word{$i} =~ /.+/)
                {
                  $abbreviate_word{$i} .= ",,$temp2[$j]";
                }
              else
                {
                  $abbreviate_word{$i} = "$temp2[$j]";
                }
            }

          #クォーテーション3つで囲まれた文字列があれば、略語候補として抽出
          @temp2 = ($str[$i] =~ /$temp[2]([^']*(|'|'')+[^']*)$temp[3]/g);
          for($j=0;$j<@temp2;$j++)
            {
              if($temp2[$j] =~ /$temp[0]([^$temp[0]]+)$temp[1]/)
                {
                  $temp2[$j] = $1;
                }

              if($abbreviate_word{$i} =~ /.+/)
                {
                  $abbreviate_word{$i} .= ",,$temp2[$j]";
                }
              else
                {
                  $abbreviate_word{$i} = "$temp2[$j]";
                }
            }
        }
    }

  return(%abbreviate_word);
}

#リダイレクトリストファイルから、リダイレクトデータを読み込む
sub load_redirect_data
{
  my($i, $j);
  my($filename);
  my($list1, $list2, $line, $num);

  $list1 = $_[1];
  $list2 = $_[2];

  $filename = $_[0];

  if(!open(FH, "<:utf8", $filename))
  {
    print "Error!! : $filename is not found\n";
   exit(0);
 }
  $num = 0;

  while($line = <FH>)
    {
      $line =~ s/^\x{FEFF}//;
      
      @temp = split(/ -> /, $line);
      $$list1[$num] = $temp[0];
      $$list2[$num] = $temp[1];
      $num++;
    }

  close(FH);
  return(\@list2, \@list2);

}