﻿###########################################################
# 略語辞書を作成するプログラム
#
# make_abbreviated_dictionary.pl
#
# written by  Shota Sumino
#
###########################################################

require 'make_redirect_list.pl';
require 'make_abstracted_page_data.pl';
require 'make_abbreviated_word_list.pl';
require 'make_abbreviated_word_list2.pl';
require 'test_another_name_list.pl';
require 'test_property_list.pl';
require 'util.pl';


use Encode qw(encode decode);
use utf8;                             # ソースがutf-8で書かれていることの宣言 :windows用
binmode STDOUT, ':encoding(shiftjis)';# 標準出力はutf-8からshiftjisへ変換 :windows用
#binmode STDERR, ':encoding(shiftjis)';# 標準エラーはutf-8からshiftjisへ変換 :windows用
#binmode STDIN, ':encoding(shiftjis)'; # 標準入力はshiftjisからutf-8へ変換 :windows用





start();

sub start#メイン関数：他ファイルのサブルーチンを呼び出す
{
  my($i, $j, $redirect_list_filename, $abstracted_page_data_filename, $redirect_filename2, $abbreviate_dictionary_filename);
  my($dir_name, $filename_key, $flag, $redirect_flag);


  
  $dir_name = $ARGV[2];

  if($ARGV[3] =~ /.+/)
    {
      $filename_key = $ARGV[3];
    }
  else
    {
      $filename_key = "latest";
    }

  if($ARGV[0] =~ /^b/)
    {
      $flag = bin2dec($ARGV[0]);
    }
  else
    {
      $flag = $ARGV[0];
    }
  
  if($ARGV[1] eq "0")
    {
      $redirect_flag = 0;
    }
  else
    {
      $redirect_flag = 1;
    }


  if(1 && ($dir_name ne ""))#リダイレクトタイトルリストを新規作成する場合は1、既に作ってある場合は0
    {
      #リダイレクトリストの作成
      $redirect_list_filename = make_redirect_list::make_redirect_list($dir_name, $filename_key);
    }
  else
    {
      $redirect_list_filename = "redirect_title_list.txt";
    }

  
  if(1 && ($dir_name ne ""))#ページデータの新規抽出を行う場合は1、すでに抽出してある場合は0
    {
      #リダイレクトリストの「リダイレクト先」に含まれるページデータを抽出する
      #同時にリダイレクトリストのソートを行う
      ($abstracted_page_data_filename, $redirect_filename2) = make_abstracted_page_data::make_abstracted_page_data($dir_name, $filename_key, $redirect_list_filename);
    }
  else
    {
      $abstracted_page_data_filename ="abstracted_page_data.dat";
      $redirect_filename2 = "redirect_title_list_sorted.txt";
    }

  #抽出したページデータから略語辞書を作成する
  $abbreviate_dictionary_filename = make_abbreviated_word_list::make_abbreviated_word_list($redirect_filename2, $abstracted_page_data_filename, $flag, $redirect_flag);
  #$abbreviate_dictionary_filename = make_abbreviated_word_list2::make_abbreviated_word_list($redirect_filename2, $abstracted_page_data_filename, $flag, $redirect_flag);


  #$abbreviate_dictionary_filename = test_another_name_list::test_another_name_list($redirect_filename2, $abstracted_page_data_filename, $flag, $redirect_flag);
  #$abbreviate_dictionary_filename = test_property_list::test_property_list($redirect_filename2, $abstracted_page_data_filename, $flag, $redirect_flag);

}


sub bin2dec#2進数で入力された引数を10進数にする
{
    my $val = shift;
    my $ret = 0;
    my $i = 1;
    
    foreach my $num (reverse split //, $val) {
        if ($num == 1) {
            $ret = $ret + $i;
        }
        $i = $i * 2;
    }
    return $ret;
}
